;*********************************
;* Jungle Jag - JagCode 500 Game *
;*********************************
;
; by Cedric Bourse, (a.k.a Orion_) [2007]
;
; http://onorisoft.info/
;
; This Source Code is licensed under the term of the following Creative Commons License:
; http://creativecommons.org/licenses/by-nc/3.0/
;
; You are free:
;  * to Share : to copy, distribute and transmit the work
;  * to Remix : to adapt the work
;
; Under the following conditions:
;  * Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).
;  * Noncommercial. You may not use this work for commercial purposes.
;  * For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.
;  * Any of the above conditions can be waived if you get permission from the copyright holder.
;  * Nothing in this license impairs or restricts the author's moral rights.
;

;********************
;- Main Ram Data(s) -
;********************

	.data


; Vars
	.long
hero_jump:	dc.w	0	; 1 = fall, 0 = normal, -1 = jump
hero_anim:	dc.w	0
hero_wait:	dc.w	0
hero_move:	dc.w	0
hero_moveliane:	dc.w	0
hero_sens:	dc.w	0
hero_x:		dc.w	0
hero_y:		dc.w	0
hero_ox:	dc.w	0
hero_oy:	dc.w	0
hero_sid:	dc.w	0
hero_mort:	dc.w	0
hero_liane:	dc.w	0


jump_vel:	dc.w	0	; jump velocity
prev_jump:	dc.w	0
prev_liane:	dc.w	0

board_limit:	dc.w	0
scroll_x:	dc.w	0
ennemy_num:	dc.w	0
items_num:	dc.w	0
last_stop:	dc.w	0
nitems:		dc.w	0
coeur:		dc.w	0
game_over:	dc.w	0
win:		dc.w	0
coeur_sid:	dc.w	0

phase:		dc.w	0
level_n:	dc.w	0
fade_cnt:	dc.w	0

dbug_mode:	dc.w	0

	.long

; Ennemy Info Struct (2 long)
EnnemyInfo:
	dc.l	ennemy1		; gfx
	dc.w	32,24		; x,y
	dc.l	ennemy2
	dc.w	32,24
	dc.l	ennemy3
	dc.w	48,24


;---------------------
;- Maps
	.include	"map1.spm"
	.include	"map2.spm"
	.include	"map3.spm"
	.include	"map4.spm"
	.include	"map5.spm"

	.long
maplist:	dc.l	map1,map2,map3,map4,map5,0

	.long
current_map:
	dc.w	0,0
	dc.l	0,cur_layer1


;---------------------
; Gfx
	.include	"palette.s"

		.phrase
ennemy1:	.incbin	"gfx\\ennemy1.rgb"
		.phrase
ennemy2:	.incbin	"gfx\\ennemy2.rgb"
		.phrase
ennemy3:	.incbin	"gfx\\ennemy3.rgb"
		.phrase
hero:		.incbin	"gfx\\hero.rgb"
		.phrase
tileset:	.incbin	"gfx\\tileset.rgb"
		.phrase
items:		.incbin	"gfx\\items.rgb"
		.phrase
font:		.incbin	"gfx\\font.rgb"
		.phrase
font2:		.incbin	"gfx\\font2.rgb"
		.phrase
Background:	.incbin	"gfx\\mountain.rgb"
		.phrase
MenuBack:	.incbin	"gfx\\back.rgb"


;---------------------
; Sfx

SFX_Win:	.incbin	"sfx\\win.raw"
SFX_WinE:
SFX_Lose:	.incbin	"sfx\\lose.raw"
SFX_LoseE:
SFX_Jump:	.incbin	"sfx\\jump.raw"
SFX_JumpE:
SFX_Diam:	.incbin	"sfx\\diam.raw"
SFX_DiamE:
SFX_Dead:	.incbin	"sfx\\dead.raw"
SFX_DeadE:
SFX_Valid:	.incbin	"sfx\\valid.raw"
SFX_ValidE:
SFX_Credits:	.incbin	"sfx\\credits.raw"
SFX_CreditsE:


;---------------------
;- Texts

	.long
winnertext:
	dc.w	(320-(9*32))/2,(256-32)/2
	dc.b	"WELL DONE",0

	.long
winnertextEnd1:
	dc.w	(320-(3*32))/2,(256-(32*3))/2
	dc.b	"YOU",0
	.long
winnertextEnd2:
	dc.w	(320-(8*32))/2,((256-(32*3))/2)+32
	dc.b	"FINISHED",0
	.long
winnertextEnd3:
	dc.w	(320-(8*32))/2,((256-(32*3))/2)+64
	dc.b	"THE GAME",0

	.long
gameovertext:
	dc.w	(320-(9*32))/2,(256-32)/2
	dc.b	"GAME OVER",0

	.long
menutextB:
	dc.w	0,20
	dc.b	"JUNGLE JAG",0

	.long
creditstextB:
	dc.w	(320-(7*32))/2,20
	dc.b	"CREDITS",0

; In case of RenderSmallTextGroup call ONLY: ->
; Small Font Text MUST be word aligned !
; use 0 to terminate string, use 0 for padding, -1 X position for terminating a group of text
; must not exceed 29 char ! (0 not included) else -> off screen
;Alignment Verif"--**--**--**--**--**--**--**-0

	.long
menutextS:
	dc.w	5,70
	dc.b	"A @ ADJUST SCREEN WITH ARROW",0,0
	dc.w	5,90
	dc.b	"B @ START GAME",0,0
	dc.w	5,110
	dc.b	"C @ CREDITS SCREEN",0
	dc.w	5,180
	dc.b	"@ INGAME CONTROLS @",0
	dc.w	5,195
	dc.b	"A @ CATCH A LIANA",0
	dc.w	5,205
	dc.b	"B @ JUMP",0,0
	dc.w	-1

	.long
creditstextS:
	dc.w	5,80
	dc.b	"CODE @ ORION",0,0
	dc.w	5,95
	dc.b	"INGAME GRAPHICS @",0
	dc.w	32,105
	dc.b	"ARI FELDMAN SPRITELIB GPL",0
	dc.w	5,120
	dc.b	"FONT @ SPAZ",0
	dc.w	5,135
	dc.b	"MUSIC SAMPLES @ ASOBEAT",0
	dc.w	5,180
	dc.b	"THANKS TO SCPCD AND",0
	dc.w	28,190
	dc.b	"ZEROSQUARE FOR BETATESTING",0,0
	dc.w	5,205
	dc.b	"THANKS TO EVERYONE",0,0
	dc.w	80,215
	dc.b	"OF THE JAGWARE TEAM",0
	dc.w	-1


;************************
;- Main Ram BSS Data(s) -
;************************

	.bss

	.long

	; sprite id, x,  y,  ennemy id*8, sens, anim, xstart, xend (8 word)
	; +          0   2   4            6     8     10      12
	; sprite id = -1 if no ennemy
EnnemyTable:
	ds.w	8*NOFENNEMY

	; sprite id, item id, x, y, taken (5 word)
	; +          0        2  4  6
	; sprite id = -1 if no ennemy
ItemsTable:
	ds.w	5*NOFITEMS

FontPalette:
	ds.w	15
GamePalette:
	ds.w	170

	.long
cur_layer1:
	ds.b	100*16

	.phrase
LevelBuffer:			; Space for the Complete Level Render
